<Query Kind="Program">
  <Namespace>System.Runtime.Serialization</Namespace>
  <Namespace>System.Text.Json</Namespace>
  <Namespace>System.Text.Json.Serialization</Namespace>
  <Namespace>System.Diagnostics.Tracing</Namespace>
</Query>

// Ten program jest celowo niewydajny. Można go wykorzystać do ćwiczenia technik diagnostycznych opisanych w rozdziale 13.

void Main()
{
	// Narzędzia diagnostyczne potrzebują identyfikatora procesu:
	Console.WriteLine ($"Identyfikator procesu {Process.GetCurrentProcess().Id}");
	MemoryLeak();
}

static Dictionary<string, int> cacheThatNeverCleansUp = new Dictionary<string, int>();

void MemoryLeak()
{
	// Wyobraź sobie, że to są skomplikowane obliczenia warte zapisania w pamięci podręcznej
	int CalculateSentenceScore (string sentence)
	{
		Stopwatch watch = Stopwatch.StartNew();
		try
		{
			if (cacheThatNeverCleansUp.TryGetValue (sentence, out int score))
				return score;

			var calculatedScore = sentence.Split (' ').Count();
			cacheThatNeverCleansUp.Add (sentence, calculatedScore);
			return calculatedScore;
		}
		finally
		{
			MyEventCounterSource.Log.Request(sentence, (float)watch.ElapsedMilliseconds);
		}
	}

	while (true) // Symulacja np. usługi sieciowej, która przyjmuje żądania
	{
		var input = RandomSentence();
		var score = CalculateSentenceScore (input);
		// Usługa sieciowa może zwrócić wynik do wywołującego
	}
}

string RandomSentence()
{
	const string alpha = "abcdefghijklmnopqrstuvwxyz";
	List<string> words = new List<string>();
	int numWords = rnd.Next (2, 15);
	for (int w = 0; w < numWords; w++)
	{
		int wordLen = rnd.Next (1, 10);
		words.Add (new string (Enumerable.Repeat (alpha, wordLen)
			.Select (_ => _ [rnd.Next (_.Length)]).ToArray()));
	}
	return string.Join (' ', words);
}

int [] LongRandomArray (int size)
{
	return Enumerable.Repeat (0, size).Select (i => rnd.Next()).ToArray();
}

Random rnd = new Random();

[EventSource(Name = "My-EventCounter-Minimal")]
public sealed class MyEventCounterSource : EventSource
{
	public static MyEventCounterSource Log = new MyEventCounterSource();
	private EventCounter requestCounter;

	private MyEventCounterSource() : base (EventSourceSettings.EtwSelfDescribingEventFormat)
	{
		this.requestCounter = new EventCounter ("Sentence Request", this);
	}

	public void Request (string sentence, float elapsedMSec)
	{
		WriteEvent (1, sentence, elapsedMSec);
		this.requestCounter.WriteMetric (elapsedMSec);
	}
}